/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lspeed.eui;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.eui.HexInput;
import ibm.nways.jdm.eui.HexInputRO;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.LongNumericInput;
import ibm.nways.jdm.eui.NumericInput;
import ibm.nways.jdm.eui.PropertySection;
import ibm.nways.jdm.eui.SingleChoiceInput;
import ibm.nways.jdm.eui.SingleChoiceInputRO;
import ibm.nways.jdm.eui.StringInput;
import ibm.nways.jdm.eui.StringInputRO;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.lspeed.VBridgePortsCreateWidget;
import ibm.nways.lspeed.model.LsBridgeExtsModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class VBridgeBasePanel
extends DestinationPropBook {
    protected static ResourceBundle enumStrings = null;
    protected static ResourceBundle myResources = null;
    private static String title = "VBridge General Info";
    protected boolean containsWritableField = false;
    protected boolean containsCreatableField = false;
    protected GenModel LsBridgeExts_model;
    protected GeneralSection GeneralPropertySection;
    protected BridgeBaseSection BridgeBasePropertySection;
    protected StpInfoSection StpInfoPropertySection;
    protected StpExtensionsSection StpExtensionsPropertySection;
    protected TransparentSection TransparentPropertySection;
    protected VBridgeWizardSection VBridgeWizardPropertySection;
    protected ModelInfo PanelInfo;
    protected ModelInfo StpExtensionsInfo;
    protected ModelInfo LsBridgeGenInfoInfo;
    protected boolean errorsFound = false;

    private static void loadStatics() {
        try {
            if (enumStrings == null) {
                enumStrings = ResourceBundle.getBundle("ibm.nways.lspeed.eui.EnumeratedResources");
            }
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.lspeed.eui.VBridgeBasePanelResources");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to access translation resources for panel VBridgeBase");
        }
    }

    public static String getTitle() {
        VBridgeBasePanel.loadStatics();
        if (myResources != null) {
            title = VBridgeBasePanel.getNLSString("VBridgeBasePanelTitle");
        }
        return title;
    }

    private static ResourceBundle getEnumStrings() {
        if (enumStrings == null) {
            VBridgeBasePanel.loadStatics();
        }
        return enumStrings;
    }

    public VBridgeBasePanel() {
        VBridgeBasePanel.loadStatics();
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public String getDestinationTitle() {
        return VBridgeBasePanel.getTitle();
    }

    protected void getModels() {
        this.LsBridgeExts_model = (GenModel)this.getModel();
    }

    public void addSections() {
        this.getModels();
        this.addGeneralSection();
        this.addBridgeBaseSection();
        this.addStpInfoSection();
        this.addStpExtensionsSection();
        this.addTransparentSection();
        this.addVBridgeWizardSection();
        if (this.containsCreatableField) {
            this.addCreateButton();
        }
        if (this.containsWritableField) {
            this.addApplyButton();
        }
        this.addRefreshButton();
        this.addHelpButton();
        this.reset();
    }

    protected void addGeneralSection() {
        this.GeneralPropertySection = new GeneralSection();
        this.GeneralPropertySection.layoutSection();
        this.addSection(VBridgeBasePanel.getNLSString("GeneralSectionTitle"), this.GeneralPropertySection);
    }

    protected void addBridgeBaseSection() {
        this.BridgeBasePropertySection = new BridgeBaseSection();
        this.BridgeBasePropertySection.layoutSection();
        this.addSection(VBridgeBasePanel.getNLSString("BridgeBaseSectionTitle"), this.BridgeBasePropertySection);
    }

    protected void addStpInfoSection() {
        this.StpInfoPropertySection = new StpInfoSection();
        this.StpInfoPropertySection.layoutSection();
        this.addSection(VBridgeBasePanel.getNLSString("StpInfoSectionTitle"), this.StpInfoPropertySection);
    }

    protected void addStpExtensionsSection() {
        this.StpExtensionsPropertySection = new StpExtensionsSection();
        this.StpExtensionsPropertySection.layoutSection();
        this.addSection(VBridgeBasePanel.getNLSString("StpExtensionsSectionTitle"), this.StpExtensionsPropertySection);
    }

    protected void addTransparentSection() {
        this.TransparentPropertySection = new TransparentSection();
        this.TransparentPropertySection.layoutSection();
        this.addSection(VBridgeBasePanel.getNLSString("TransparentSectionTitle"), this.TransparentPropertySection);
    }

    protected void addVBridgeWizardSection() {
        this.VBridgeWizardPropertySection = new VBridgeWizardSection();
        this.VBridgeWizardPropertySection.layoutSection();
        this.addSection(VBridgeBasePanel.getNLSString("VBridgeWizardSectionTitle"), this.VBridgeWizardPropertySection);
    }

    protected void panelRowChange() {
        if (this.GeneralPropertySection != null) {
            this.GeneralPropertySection.rowChange();
        }
        if (this.BridgeBasePropertySection != null) {
            this.BridgeBasePropertySection.rowChange();
        }
        if (this.StpInfoPropertySection != null) {
            this.StpInfoPropertySection.rowChange();
        }
        if (this.StpExtensionsPropertySection != null) {
            this.StpExtensionsPropertySection.rowChange();
        }
        if (this.TransparentPropertySection != null) {
            this.TransparentPropertySection.rowChange();
        }
        if (this.VBridgeWizardPropertySection != null) {
            this.VBridgeWizardPropertySection.rowChange();
        }
    }

    protected void displayMsg(String string) {
        if (this.getBrowser() != null) {
            this.getBrowser().displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        if (myResources == null) {
            return string;
        }
        try {
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    protected String getOverride(String string, String string2) {
        String string3 = null;
        try {
            string3 = NavFieldOverride.getFieldOverride(this.getNavContext(), string);
        }
        catch (ClassCastException classCastException) {
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (NullPointerException nullPointerException) {}
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public void reset() {
        this.displayMsg(VBridgeBasePanel.getNLSString("startResetMsg"));
        try {
            if (this.LsBridgeExts_model != null) {
                this.LsBridgeGenInfoInfo = this.LsBridgeExts_model.getInfo("LsBridgeGenInfo");
                this.PanelInfo = this.LsBridgeExts_model.getInfo("Panel");
                this.StpExtensionsInfo = this.LsBridgeExts_model.getInfo("StpExtensions");
            }
        }
        catch (RemoteException remoteException) {
            System.out.println(remoteException);
            remoteException.printStackTrace();
        }
        this.errorsFound = false;
        super.reset();
        if (!this.errorsFound) {
            this.displayMsg(VBridgeBasePanel.getNLSString("endResetMsg"));
            return;
        }
        this.displayMsg(String.valueOf(VBridgeBasePanel.getNLSString("endResetMsg")) + " " + VBridgeBasePanel.getNLSString("noteErrorsMsg"));
    }

    public void apply() {
        this.PanelInfo = new ModelInfo();
        this.StpExtensionsInfo = new ModelInfo();
        this.LsBridgeGenInfoInfo = new ModelInfo();
        this.errorsFound = false;
        this.displayMsg(VBridgeBasePanel.getNLSString("startApplyMsg"));
        super.apply();
        if (!this.errorsFound) {
            try {
                if (this.LsBridgeExts_model != null) {
                    this.LsBridgeGenInfoInfo = this.LsBridgeExts_model.setInfo("LsBridgeGenInfo", this.LsBridgeGenInfoInfo);
                    this.PanelInfo = this.LsBridgeExts_model.setInfo("Panel", this.PanelInfo);
                    this.StpExtensionsInfo = this.LsBridgeExts_model.setInfo("StpExtensions", this.StpExtensionsInfo);
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            super.reset();
            if (!this.errorsFound) {
                this.displayMsg(VBridgeBasePanel.getNLSString("endApplyMsg"));
                return;
            }
            this.displayMsg(String.valueOf(VBridgeBasePanel.getNLSString("endApplyMsg")) + " " + VBridgeBasePanel.getNLSString("noteErrorsMsg"));
            return;
        }
        this.displayMsg(VBridgeBasePanel.getNLSString("abortApplyMsg"));
    }

    public class GeneralSection
    extends PropertySection {
        ModelInfo chunk;
        Component vbridgeNameField;
        Label vbridgeNameFieldLabel;
        boolean vbridgeNameFieldWritable = false;

        public GeneralSection() {
            VBridgeBasePanel.this = VBridgeBasePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createvbridgeNameField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.LsBridgeGenInfo.BridgeName.access", "read-write");
            String string2 = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.LsBridgeGenInfo.BridgeName.length", "255");
            this.vbridgeNameFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.vbridgeNameFieldLabel = new Label(VBridgeBasePanel.getNLSString("vbridgeNameLabel"), 2);
            if (this.vbridgeNameFieldWritable) {
                StringInput stringInput = new StringInput();
                stringInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.vbridgeNameFieldLabel, (Component)stringInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return stringInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.vbridgeNameFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getvbridgeNameField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vbridgeNameField);
            this.validatevbridgeNameField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvbridgeNameField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.vbridgeNameField);
                jDMInput.setValue(object);
                this.validatevbridgeNameField();
            }
        }

        protected boolean validatevbridgeNameField() {
            JDMInput jDMInput = (JDMInput)((Object)this.vbridgeNameField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.vbridgeNameFieldLabel.setForeground(Color.yellow);
            } else {
                this.vbridgeNameFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.vbridgeNameField = this.createvbridgeNameField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.vbridgeNameField)).ignoreValue() && this.vbridgeNameFieldWritable) {
                    VBridgeBasePanel.this.LsBridgeGenInfoInfo.add("LsBridgeGenInfo.BridgeName", this.getvbridgeNameField());
                    return;
                }
            } else {
                VBridgeBasePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            VBridgeBasePanel.this.displayMsg(VBridgeBasePanel.getNLSString("accessDataMsg"));
            try {
                this.setvbridgeNameField(VBridgeBasePanel.this.LsBridgeGenInfoInfo.get("LsBridgeGenInfo.BridgeName"));
            }
            catch (NullPointerException nullPointerException) {}
            VBridgeBasePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.doLayout();
        }

        public boolean validateSection() {
            return ((JDMInput)((Object)this.vbridgeNameField)).ignoreValue() || this.validatevbridgeNameField();
        }
    }

    public class BridgeBaseSection
    extends PropertySection {
        ModelInfo chunk;
        Component dot1dBaseBridgeAddressField;
        Component dot1dBaseNumPortsField;
        Component dot1dBaseTypeField;
        Label dot1dBaseBridgeAddressFieldLabel;
        Label dot1dBaseNumPortsFieldLabel;
        Label dot1dBaseTypeFieldLabel;
        boolean dot1dBaseBridgeAddressFieldWritable = false;
        boolean dot1dBaseNumPortsFieldWritable = false;
        boolean dot1dBaseTypeFieldWritable = false;

        public BridgeBaseSection() {
            VBridgeBasePanel.this = VBridgeBasePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createdot1dBaseBridgeAddressField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.Panel.Dot1dBaseBridgeAddress.access", "read-only");
            String string2 = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.Panel.Dot1dBaseBridgeAddress.length", "6");
            this.dot1dBaseBridgeAddressFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.dot1dBaseBridgeAddressFieldLabel = new Label(VBridgeBasePanel.getNLSString("dot1dBaseBridgeAddressLabel"), 2);
            if (this.dot1dBaseBridgeAddressFieldWritable) {
                HexInput hexInput = new HexInput();
                hexInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.dot1dBaseBridgeAddressFieldLabel, (Component)hexInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return hexInput;
            }
            HexInputRO hexInputRO = new HexInputRO();
            this.addRow(this.dot1dBaseBridgeAddressFieldLabel, (Component)hexInputRO);
            return hexInputRO;
        }

        protected Serializable getdot1dBaseBridgeAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dBaseBridgeAddressField);
            this.validatedot1dBaseBridgeAddressField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setdot1dBaseBridgeAddressField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.dot1dBaseBridgeAddressField);
                jDMInput.setValue(object);
                this.validatedot1dBaseBridgeAddressField();
            }
        }

        protected boolean validatedot1dBaseBridgeAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dBaseBridgeAddressField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.dot1dBaseBridgeAddressFieldLabel.setForeground(Color.yellow);
            } else {
                this.dot1dBaseBridgeAddressFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createdot1dBaseNumPortsField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.Panel.Dot1dBaseNumPorts.access", "read-only");
            this.dot1dBaseNumPortsFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.dot1dBaseNumPortsFieldLabel = new Label(VBridgeBasePanel.getNLSString("dot1dBaseNumPortsLabel"), 2);
            if (this.dot1dBaseNumPortsFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.dot1dBaseNumPortsFieldLabel, (Component)numericInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.dot1dBaseNumPortsFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getdot1dBaseNumPortsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dBaseNumPortsField);
            this.validatedot1dBaseNumPortsField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setdot1dBaseNumPortsField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.dot1dBaseNumPortsField);
                jDMInput.setValue(object);
                this.validatedot1dBaseNumPortsField();
            }
        }

        protected boolean validatedot1dBaseNumPortsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dBaseNumPortsField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.dot1dBaseNumPortsFieldLabel.setForeground(Color.yellow);
            } else {
                this.dot1dBaseNumPortsFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createdot1dBaseTypeField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.Panel.Dot1dBaseType.access", "read-only");
            this.dot1dBaseTypeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.dot1dBaseTypeFieldLabel = new Label(VBridgeBasePanel.getNLSString("dot1dBaseTypeLabel"), 2);
            if (this.dot1dBaseTypeFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(LsBridgeExtsModel.Panel.Dot1dBaseTypeEnum.symbolicValues, LsBridgeExtsModel.Panel.Dot1dBaseTypeEnum.numericValues, VBridgeBasePanel.getEnumStrings());
                this.addRow(this.dot1dBaseTypeFieldLabel, (Component)singleChoiceInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(LsBridgeExtsModel.Panel.Dot1dBaseTypeEnum.symbolicValues, LsBridgeExtsModel.Panel.Dot1dBaseTypeEnum.numericValues, VBridgeBasePanel.getEnumStrings());
            this.addRow(this.dot1dBaseTypeFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getdot1dBaseTypeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dBaseTypeField);
            this.validatedot1dBaseTypeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setdot1dBaseTypeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.dot1dBaseTypeField);
                jDMInput.setValue(object);
                this.validatedot1dBaseTypeField();
            }
        }

        protected boolean validatedot1dBaseTypeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dBaseTypeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.dot1dBaseTypeFieldLabel.setForeground(Color.yellow);
            } else {
                this.dot1dBaseTypeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.dot1dBaseBridgeAddressField = this.createdot1dBaseBridgeAddressField();
            this.dot1dBaseNumPortsField = this.createdot1dBaseNumPortsField();
            this.dot1dBaseTypeField = this.createdot1dBaseTypeField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.dot1dBaseBridgeAddressField)).ignoreValue() && this.dot1dBaseBridgeAddressFieldWritable) {
                    VBridgeBasePanel.this.PanelInfo.add("Panel.Dot1dBaseBridgeAddress", this.getdot1dBaseBridgeAddressField());
                }
                if (!((JDMInput)((Object)this.dot1dBaseNumPortsField)).ignoreValue() && this.dot1dBaseNumPortsFieldWritable) {
                    VBridgeBasePanel.this.PanelInfo.add("Panel.Dot1dBaseNumPorts", this.getdot1dBaseNumPortsField());
                }
                if (!((JDMInput)((Object)this.dot1dBaseTypeField)).ignoreValue() && this.dot1dBaseTypeFieldWritable) {
                    VBridgeBasePanel.this.PanelInfo.add("Panel.Dot1dBaseType", this.getdot1dBaseTypeField());
                    return;
                }
            } else {
                VBridgeBasePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            VBridgeBasePanel.this.displayMsg(VBridgeBasePanel.getNLSString("accessDataMsg"));
            try {
                this.setdot1dBaseBridgeAddressField(VBridgeBasePanel.this.PanelInfo.get("Panel.Dot1dBaseBridgeAddress"));
                this.setdot1dBaseNumPortsField(VBridgeBasePanel.this.PanelInfo.get("Panel.Dot1dBaseNumPorts"));
                this.setdot1dBaseTypeField(VBridgeBasePanel.this.PanelInfo.get("Panel.Dot1dBaseType"));
            }
            catch (NullPointerException nullPointerException) {}
            VBridgeBasePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.doLayout();
        }

        public boolean validateSection() {
            return true;
        }
    }

    public class StpInfoSection
    extends PropertySection {
        ModelInfo chunk;
        Component dot1dStpProtocolSpecificationField;
        Component dot1dStpPriorityField;
        Component dot1dStpTimeSinceTopologyChangeField;
        Component dot1dStpTopChangesField;
        Component dot1dStpDesignatedRootField;
        Component dot1dStpRootCostField;
        Component dot1dStpRootPortField;
        Component dot1dStpMaxAgeField;
        Component dot1dStpHelloTimeField;
        Component dot1dStpHoldTimeField;
        Component dot1dStpForwardDelayField;
        Component dot1dStpBridgeMaxAgeField;
        Component dot1dStpBridgeHelloTimeField;
        Component dot1dStpBridgeForwardDelayField;
        Label dot1dStpProtocolSpecificationFieldLabel;
        Label dot1dStpPriorityFieldLabel;
        Label dot1dStpTimeSinceTopologyChangeFieldLabel;
        Label dot1dStpTopChangesFieldLabel;
        Label dot1dStpDesignatedRootFieldLabel;
        Label dot1dStpRootCostFieldLabel;
        Label dot1dStpRootPortFieldLabel;
        Label dot1dStpMaxAgeFieldLabel;
        Label dot1dStpHelloTimeFieldLabel;
        Label dot1dStpHoldTimeFieldLabel;
        Label dot1dStpForwardDelayFieldLabel;
        Label dot1dStpBridgeMaxAgeFieldLabel;
        Label dot1dStpBridgeHelloTimeFieldLabel;
        Label dot1dStpBridgeForwardDelayFieldLabel;
        boolean dot1dStpProtocolSpecificationFieldWritable = false;
        boolean dot1dStpPriorityFieldWritable = false;
        boolean dot1dStpTimeSinceTopologyChangeFieldWritable = false;
        boolean dot1dStpTopChangesFieldWritable = false;
        boolean dot1dStpDesignatedRootFieldWritable = false;
        boolean dot1dStpRootCostFieldWritable = false;
        boolean dot1dStpRootPortFieldWritable = false;
        boolean dot1dStpMaxAgeFieldWritable = false;
        boolean dot1dStpHelloTimeFieldWritable = false;
        boolean dot1dStpHoldTimeFieldWritable = false;
        boolean dot1dStpForwardDelayFieldWritable = false;
        boolean dot1dStpBridgeMaxAgeFieldWritable = false;
        boolean dot1dStpBridgeHelloTimeFieldWritable = false;
        boolean dot1dStpBridgeForwardDelayFieldWritable = false;

        public StpInfoSection() {
            VBridgeBasePanel.this = VBridgeBasePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createdot1dStpProtocolSpecificationField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.Panel.Dot1dStpProtocolSpecification.access", "read-only");
            this.dot1dStpProtocolSpecificationFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.dot1dStpProtocolSpecificationFieldLabel = new Label(VBridgeBasePanel.getNLSString("dot1dStpProtocolSpecificationLabel"), 2);
            if (this.dot1dStpProtocolSpecificationFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(LsBridgeExtsModel.Panel.Dot1dStpProtocolSpecificationEnum.symbolicValues, LsBridgeExtsModel.Panel.Dot1dStpProtocolSpecificationEnum.numericValues, VBridgeBasePanel.getEnumStrings());
                this.addRow(this.dot1dStpProtocolSpecificationFieldLabel, (Component)singleChoiceInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(LsBridgeExtsModel.Panel.Dot1dStpProtocolSpecificationEnum.symbolicValues, LsBridgeExtsModel.Panel.Dot1dStpProtocolSpecificationEnum.numericValues, VBridgeBasePanel.getEnumStrings());
            this.addRow(this.dot1dStpProtocolSpecificationFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getdot1dStpProtocolSpecificationField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpProtocolSpecificationField);
            this.validatedot1dStpProtocolSpecificationField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setdot1dStpProtocolSpecificationField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpProtocolSpecificationField);
                jDMInput.setValue(object);
                this.validatedot1dStpProtocolSpecificationField();
            }
        }

        protected boolean validatedot1dStpProtocolSpecificationField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpProtocolSpecificationField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.dot1dStpProtocolSpecificationFieldLabel.setForeground(Color.yellow);
            } else {
                this.dot1dStpProtocolSpecificationFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createdot1dStpPriorityField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.Panel.Dot1dStpPriority.access", "read-write");
            this.dot1dStpPriorityFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.dot1dStpPriorityFieldLabel = new Label(VBridgeBasePanel.getNLSString("dot1dStpPriorityLabel"), 2);
            if (this.dot1dStpPriorityFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 65535);
                this.addRow(this.dot1dStpPriorityFieldLabel, (Component)numericInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.dot1dStpPriorityFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getdot1dStpPriorityField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpPriorityField);
            this.validatedot1dStpPriorityField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setdot1dStpPriorityField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpPriorityField);
                jDMInput.setValue(object);
                this.validatedot1dStpPriorityField();
            }
        }

        protected boolean validatedot1dStpPriorityField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpPriorityField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.dot1dStpPriorityFieldLabel.setForeground(Color.yellow);
            } else {
                this.dot1dStpPriorityFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createdot1dStpTimeSinceTopologyChangeField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.Panel.Dot1dStpTimeSinceTopologyChange.access", "read-only");
            this.dot1dStpTimeSinceTopologyChangeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.dot1dStpTimeSinceTopologyChangeFieldLabel = new Label(VBridgeBasePanel.getNLSString("dot1dStpTimeSinceTopologyChangeLabel"), 2);
            if (this.dot1dStpTimeSinceTopologyChangeFieldWritable) {
                LongNumericInput longNumericInput = new LongNumericInput();
                this.addRow(this.dot1dStpTimeSinceTopologyChangeFieldLabel, (Component)longNumericInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return longNumericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.dot1dStpTimeSinceTopologyChangeFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getdot1dStpTimeSinceTopologyChangeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpTimeSinceTopologyChangeField);
            this.validatedot1dStpTimeSinceTopologyChangeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setdot1dStpTimeSinceTopologyChangeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpTimeSinceTopologyChangeField);
                jDMInput.setValue(object);
                this.validatedot1dStpTimeSinceTopologyChangeField();
            }
        }

        protected boolean validatedot1dStpTimeSinceTopologyChangeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpTimeSinceTopologyChangeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.dot1dStpTimeSinceTopologyChangeFieldLabel.setForeground(Color.yellow);
            } else {
                this.dot1dStpTimeSinceTopologyChangeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createdot1dStpTopChangesField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.Panel.Dot1dStpTopChanges.access", "read-only");
            this.dot1dStpTopChangesFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.dot1dStpTopChangesFieldLabel = new Label(VBridgeBasePanel.getNLSString("dot1dStpTopChangesLabel"), 2);
            if (this.dot1dStpTopChangesFieldWritable) {
                LongNumericInput longNumericInput = new LongNumericInput();
                this.addRow(this.dot1dStpTopChangesFieldLabel, (Component)longNumericInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return longNumericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.dot1dStpTopChangesFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getdot1dStpTopChangesField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpTopChangesField);
            this.validatedot1dStpTopChangesField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setdot1dStpTopChangesField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpTopChangesField);
                jDMInput.setValue(object);
                this.validatedot1dStpTopChangesField();
            }
        }

        protected boolean validatedot1dStpTopChangesField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpTopChangesField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.dot1dStpTopChangesFieldLabel.setForeground(Color.yellow);
            } else {
                this.dot1dStpTopChangesFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createdot1dStpDesignatedRootField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.Panel.Dot1dStpDesignatedRoot.access", "read-only");
            String string2 = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.Panel.Dot1dStpDesignatedRoot.length", "8");
            this.dot1dStpDesignatedRootFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.dot1dStpDesignatedRootFieldLabel = new Label(VBridgeBasePanel.getNLSString("dot1dStpDesignatedRootLabel"), 2);
            if (this.dot1dStpDesignatedRootFieldWritable) {
                HexInput hexInput = new HexInput();
                hexInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.dot1dStpDesignatedRootFieldLabel, (Component)hexInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return hexInput;
            }
            HexInputRO hexInputRO = new HexInputRO();
            this.addRow(this.dot1dStpDesignatedRootFieldLabel, (Component)hexInputRO);
            return hexInputRO;
        }

        protected Serializable getdot1dStpDesignatedRootField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpDesignatedRootField);
            this.validatedot1dStpDesignatedRootField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setdot1dStpDesignatedRootField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpDesignatedRootField);
                jDMInput.setValue(object);
                this.validatedot1dStpDesignatedRootField();
            }
        }

        protected boolean validatedot1dStpDesignatedRootField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpDesignatedRootField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.dot1dStpDesignatedRootFieldLabel.setForeground(Color.yellow);
            } else {
                this.dot1dStpDesignatedRootFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createdot1dStpRootCostField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.Panel.Dot1dStpRootCost.access", "read-only");
            this.dot1dStpRootCostFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.dot1dStpRootCostFieldLabel = new Label(VBridgeBasePanel.getNLSString("dot1dStpRootCostLabel"), 2);
            if (this.dot1dStpRootCostFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.dot1dStpRootCostFieldLabel, (Component)numericInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.dot1dStpRootCostFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getdot1dStpRootCostField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpRootCostField);
            this.validatedot1dStpRootCostField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setdot1dStpRootCostField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpRootCostField);
                jDMInput.setValue(object);
                this.validatedot1dStpRootCostField();
            }
        }

        protected boolean validatedot1dStpRootCostField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpRootCostField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.dot1dStpRootCostFieldLabel.setForeground(Color.yellow);
            } else {
                this.dot1dStpRootCostFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createdot1dStpRootPortField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.Panel.Dot1dStpRootPort.access", "read-only");
            this.dot1dStpRootPortFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.dot1dStpRootPortFieldLabel = new Label(VBridgeBasePanel.getNLSString("dot1dStpRootPortLabel"), 2);
            if (this.dot1dStpRootPortFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.dot1dStpRootPortFieldLabel, (Component)numericInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.dot1dStpRootPortFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getdot1dStpRootPortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpRootPortField);
            this.validatedot1dStpRootPortField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setdot1dStpRootPortField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpRootPortField);
                jDMInput.setValue(object);
                this.validatedot1dStpRootPortField();
            }
        }

        protected boolean validatedot1dStpRootPortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpRootPortField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.dot1dStpRootPortFieldLabel.setForeground(Color.yellow);
            } else {
                this.dot1dStpRootPortFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createdot1dStpMaxAgeField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.Panel.Dot1dStpMaxAge.access", "read-only");
            this.dot1dStpMaxAgeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.dot1dStpMaxAgeFieldLabel = new Label(VBridgeBasePanel.getNLSString("dot1dStpMaxAgeLabel"), 2);
            if (this.dot1dStpMaxAgeFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.dot1dStpMaxAgeFieldLabel, (Component)numericInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.dot1dStpMaxAgeFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getdot1dStpMaxAgeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpMaxAgeField);
            this.validatedot1dStpMaxAgeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setdot1dStpMaxAgeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpMaxAgeField);
                jDMInput.setValue(object);
                this.validatedot1dStpMaxAgeField();
            }
        }

        protected boolean validatedot1dStpMaxAgeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpMaxAgeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.dot1dStpMaxAgeFieldLabel.setForeground(Color.yellow);
            } else {
                this.dot1dStpMaxAgeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createdot1dStpHelloTimeField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.Panel.Dot1dStpHelloTime.access", "read-only");
            this.dot1dStpHelloTimeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.dot1dStpHelloTimeFieldLabel = new Label(VBridgeBasePanel.getNLSString("dot1dStpHelloTimeLabel"), 2);
            if (this.dot1dStpHelloTimeFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.dot1dStpHelloTimeFieldLabel, (Component)numericInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.dot1dStpHelloTimeFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getdot1dStpHelloTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpHelloTimeField);
            this.validatedot1dStpHelloTimeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setdot1dStpHelloTimeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpHelloTimeField);
                jDMInput.setValue(object);
                this.validatedot1dStpHelloTimeField();
            }
        }

        protected boolean validatedot1dStpHelloTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpHelloTimeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.dot1dStpHelloTimeFieldLabel.setForeground(Color.yellow);
            } else {
                this.dot1dStpHelloTimeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createdot1dStpHoldTimeField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.Panel.Dot1dStpHoldTime.access", "read-only");
            this.dot1dStpHoldTimeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.dot1dStpHoldTimeFieldLabel = new Label(VBridgeBasePanel.getNLSString("dot1dStpHoldTimeLabel"), 2);
            if (this.dot1dStpHoldTimeFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.dot1dStpHoldTimeFieldLabel, (Component)numericInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.dot1dStpHoldTimeFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getdot1dStpHoldTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpHoldTimeField);
            this.validatedot1dStpHoldTimeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setdot1dStpHoldTimeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpHoldTimeField);
                jDMInput.setValue(object);
                this.validatedot1dStpHoldTimeField();
            }
        }

        protected boolean validatedot1dStpHoldTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpHoldTimeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.dot1dStpHoldTimeFieldLabel.setForeground(Color.yellow);
            } else {
                this.dot1dStpHoldTimeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createdot1dStpForwardDelayField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.Panel.Dot1dStpForwardDelay.access", "read-only");
            this.dot1dStpForwardDelayFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.dot1dStpForwardDelayFieldLabel = new Label(VBridgeBasePanel.getNLSString("dot1dStpForwardDelayLabel"), 2);
            if (this.dot1dStpForwardDelayFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.dot1dStpForwardDelayFieldLabel, (Component)numericInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.dot1dStpForwardDelayFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getdot1dStpForwardDelayField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpForwardDelayField);
            this.validatedot1dStpForwardDelayField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setdot1dStpForwardDelayField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpForwardDelayField);
                jDMInput.setValue(object);
                this.validatedot1dStpForwardDelayField();
            }
        }

        protected boolean validatedot1dStpForwardDelayField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpForwardDelayField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.dot1dStpForwardDelayFieldLabel.setForeground(Color.yellow);
            } else {
                this.dot1dStpForwardDelayFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createdot1dStpBridgeMaxAgeField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.Panel.Dot1dStpBridgeMaxAge.access", "read-write");
            this.dot1dStpBridgeMaxAgeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.dot1dStpBridgeMaxAgeFieldLabel = new Label(VBridgeBasePanel.getNLSString("dot1dStpBridgeMaxAgeLabel"), 2);
            if (this.dot1dStpBridgeMaxAgeFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.dot1dStpBridgeMaxAgeFieldLabel, (Component)numericInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.dot1dStpBridgeMaxAgeFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getdot1dStpBridgeMaxAgeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpBridgeMaxAgeField);
            this.validatedot1dStpBridgeMaxAgeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setdot1dStpBridgeMaxAgeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpBridgeMaxAgeField);
                jDMInput.setValue(object);
                this.validatedot1dStpBridgeMaxAgeField();
            }
        }

        protected boolean validatedot1dStpBridgeMaxAgeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpBridgeMaxAgeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.dot1dStpBridgeMaxAgeFieldLabel.setForeground(Color.yellow);
            } else {
                this.dot1dStpBridgeMaxAgeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createdot1dStpBridgeHelloTimeField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.Panel.Dot1dStpBridgeHelloTime.access", "read-write");
            this.dot1dStpBridgeHelloTimeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.dot1dStpBridgeHelloTimeFieldLabel = new Label(VBridgeBasePanel.getNLSString("dot1dStpBridgeHelloTimeLabel"), 2);
            if (this.dot1dStpBridgeHelloTimeFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.dot1dStpBridgeHelloTimeFieldLabel, (Component)numericInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.dot1dStpBridgeHelloTimeFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getdot1dStpBridgeHelloTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpBridgeHelloTimeField);
            this.validatedot1dStpBridgeHelloTimeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setdot1dStpBridgeHelloTimeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpBridgeHelloTimeField);
                jDMInput.setValue(object);
                this.validatedot1dStpBridgeHelloTimeField();
            }
        }

        protected boolean validatedot1dStpBridgeHelloTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpBridgeHelloTimeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.dot1dStpBridgeHelloTimeFieldLabel.setForeground(Color.yellow);
            } else {
                this.dot1dStpBridgeHelloTimeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createdot1dStpBridgeForwardDelayField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.Panel.Dot1dStpBridgeForwardDelay.access", "read-write");
            this.dot1dStpBridgeForwardDelayFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.dot1dStpBridgeForwardDelayFieldLabel = new Label(VBridgeBasePanel.getNLSString("dot1dStpBridgeForwardDelayLabel"), 2);
            if (this.dot1dStpBridgeForwardDelayFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.dot1dStpBridgeForwardDelayFieldLabel, (Component)numericInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.dot1dStpBridgeForwardDelayFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getdot1dStpBridgeForwardDelayField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpBridgeForwardDelayField);
            this.validatedot1dStpBridgeForwardDelayField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setdot1dStpBridgeForwardDelayField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpBridgeForwardDelayField);
                jDMInput.setValue(object);
                this.validatedot1dStpBridgeForwardDelayField();
            }
        }

        protected boolean validatedot1dStpBridgeForwardDelayField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dStpBridgeForwardDelayField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.dot1dStpBridgeForwardDelayFieldLabel.setForeground(Color.yellow);
            } else {
                this.dot1dStpBridgeForwardDelayFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.dot1dStpProtocolSpecificationField = this.createdot1dStpProtocolSpecificationField();
            this.dot1dStpPriorityField = this.createdot1dStpPriorityField();
            this.dot1dStpTimeSinceTopologyChangeField = this.createdot1dStpTimeSinceTopologyChangeField();
            this.dot1dStpTopChangesField = this.createdot1dStpTopChangesField();
            this.dot1dStpDesignatedRootField = this.createdot1dStpDesignatedRootField();
            this.dot1dStpRootCostField = this.createdot1dStpRootCostField();
            this.dot1dStpRootPortField = this.createdot1dStpRootPortField();
            this.dot1dStpMaxAgeField = this.createdot1dStpMaxAgeField();
            this.dot1dStpHelloTimeField = this.createdot1dStpHelloTimeField();
            this.dot1dStpHoldTimeField = this.createdot1dStpHoldTimeField();
            this.dot1dStpForwardDelayField = this.createdot1dStpForwardDelayField();
            this.dot1dStpBridgeMaxAgeField = this.createdot1dStpBridgeMaxAgeField();
            this.dot1dStpBridgeHelloTimeField = this.createdot1dStpBridgeHelloTimeField();
            this.dot1dStpBridgeForwardDelayField = this.createdot1dStpBridgeForwardDelayField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.dot1dStpProtocolSpecificationField)).ignoreValue() && this.dot1dStpProtocolSpecificationFieldWritable) {
                    VBridgeBasePanel.this.PanelInfo.add("Panel.Dot1dStpProtocolSpecification", this.getdot1dStpProtocolSpecificationField());
                }
                if (!((JDMInput)((Object)this.dot1dStpPriorityField)).ignoreValue() && this.dot1dStpPriorityFieldWritable) {
                    VBridgeBasePanel.this.PanelInfo.add("Panel.Dot1dStpPriority", this.getdot1dStpPriorityField());
                }
                if (!((JDMInput)((Object)this.dot1dStpTimeSinceTopologyChangeField)).ignoreValue() && this.dot1dStpTimeSinceTopologyChangeFieldWritable) {
                    VBridgeBasePanel.this.PanelInfo.add("Panel.Dot1dStpTimeSinceTopologyChange", this.getdot1dStpTimeSinceTopologyChangeField());
                }
                if (!((JDMInput)((Object)this.dot1dStpTopChangesField)).ignoreValue() && this.dot1dStpTopChangesFieldWritable) {
                    VBridgeBasePanel.this.PanelInfo.add("Panel.Dot1dStpTopChanges", this.getdot1dStpTopChangesField());
                }
                if (!((JDMInput)((Object)this.dot1dStpDesignatedRootField)).ignoreValue() && this.dot1dStpDesignatedRootFieldWritable) {
                    VBridgeBasePanel.this.PanelInfo.add("Panel.Dot1dStpDesignatedRoot", this.getdot1dStpDesignatedRootField());
                }
                if (!((JDMInput)((Object)this.dot1dStpRootCostField)).ignoreValue() && this.dot1dStpRootCostFieldWritable) {
                    VBridgeBasePanel.this.PanelInfo.add("Panel.Dot1dStpRootCost", this.getdot1dStpRootCostField());
                }
                if (!((JDMInput)((Object)this.dot1dStpRootPortField)).ignoreValue() && this.dot1dStpRootPortFieldWritable) {
                    VBridgeBasePanel.this.PanelInfo.add("Panel.Dot1dStpRootPort", this.getdot1dStpRootPortField());
                }
                if (!((JDMInput)((Object)this.dot1dStpMaxAgeField)).ignoreValue() && this.dot1dStpMaxAgeFieldWritable) {
                    VBridgeBasePanel.this.PanelInfo.add("Panel.Dot1dStpMaxAge", this.getdot1dStpMaxAgeField());
                }
                if (!((JDMInput)((Object)this.dot1dStpHelloTimeField)).ignoreValue() && this.dot1dStpHelloTimeFieldWritable) {
                    VBridgeBasePanel.this.PanelInfo.add("Panel.Dot1dStpHelloTime", this.getdot1dStpHelloTimeField());
                }
                if (!((JDMInput)((Object)this.dot1dStpHoldTimeField)).ignoreValue() && this.dot1dStpHoldTimeFieldWritable) {
                    VBridgeBasePanel.this.PanelInfo.add("Panel.Dot1dStpHoldTime", this.getdot1dStpHoldTimeField());
                }
                if (!((JDMInput)((Object)this.dot1dStpForwardDelayField)).ignoreValue() && this.dot1dStpForwardDelayFieldWritable) {
                    VBridgeBasePanel.this.PanelInfo.add("Panel.Dot1dStpForwardDelay", this.getdot1dStpForwardDelayField());
                }
                if (!((JDMInput)((Object)this.dot1dStpBridgeMaxAgeField)).ignoreValue() && this.dot1dStpBridgeMaxAgeFieldWritable) {
                    VBridgeBasePanel.this.PanelInfo.add("Panel.Dot1dStpBridgeMaxAge", this.getdot1dStpBridgeMaxAgeField());
                }
                if (!((JDMInput)((Object)this.dot1dStpBridgeHelloTimeField)).ignoreValue() && this.dot1dStpBridgeHelloTimeFieldWritable) {
                    VBridgeBasePanel.this.PanelInfo.add("Panel.Dot1dStpBridgeHelloTime", this.getdot1dStpBridgeHelloTimeField());
                }
                if (!((JDMInput)((Object)this.dot1dStpBridgeForwardDelayField)).ignoreValue() && this.dot1dStpBridgeForwardDelayFieldWritable) {
                    VBridgeBasePanel.this.PanelInfo.add("Panel.Dot1dStpBridgeForwardDelay", this.getdot1dStpBridgeForwardDelayField());
                    return;
                }
            } else {
                VBridgeBasePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            VBridgeBasePanel.this.displayMsg(VBridgeBasePanel.getNLSString("accessDataMsg"));
            try {
                this.setdot1dStpProtocolSpecificationField(VBridgeBasePanel.this.PanelInfo.get("Panel.Dot1dStpProtocolSpecification"));
                this.setdot1dStpPriorityField(VBridgeBasePanel.this.PanelInfo.get("Panel.Dot1dStpPriority"));
                this.setdot1dStpTimeSinceTopologyChangeField(VBridgeBasePanel.this.PanelInfo.get("Panel.Dot1dStpTimeSinceTopologyChange"));
                this.setdot1dStpTopChangesField(VBridgeBasePanel.this.PanelInfo.get("Panel.Dot1dStpTopChanges"));
                this.setdot1dStpDesignatedRootField(VBridgeBasePanel.this.PanelInfo.get("Panel.Dot1dStpDesignatedRoot"));
                this.setdot1dStpRootCostField(VBridgeBasePanel.this.PanelInfo.get("Panel.Dot1dStpRootCost"));
                this.setdot1dStpRootPortField(VBridgeBasePanel.this.PanelInfo.get("Panel.Dot1dStpRootPort"));
                this.setdot1dStpMaxAgeField(VBridgeBasePanel.this.PanelInfo.get("Panel.Dot1dStpMaxAge"));
                this.setdot1dStpHelloTimeField(VBridgeBasePanel.this.PanelInfo.get("Panel.Dot1dStpHelloTime"));
                this.setdot1dStpHoldTimeField(VBridgeBasePanel.this.PanelInfo.get("Panel.Dot1dStpHoldTime"));
                this.setdot1dStpForwardDelayField(VBridgeBasePanel.this.PanelInfo.get("Panel.Dot1dStpForwardDelay"));
                this.setdot1dStpBridgeMaxAgeField(VBridgeBasePanel.this.PanelInfo.get("Panel.Dot1dStpBridgeMaxAge"));
                this.setdot1dStpBridgeHelloTimeField(VBridgeBasePanel.this.PanelInfo.get("Panel.Dot1dStpBridgeHelloTime"));
                this.setdot1dStpBridgeForwardDelayField(VBridgeBasePanel.this.PanelInfo.get("Panel.Dot1dStpBridgeForwardDelay"));
            }
            catch (NullPointerException nullPointerException) {}
            VBridgeBasePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.doLayout();
        }

        public boolean validateSection() {
            if (!((JDMInput)((Object)this.dot1dStpPriorityField)).ignoreValue() && !this.validatedot1dStpPriorityField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.dot1dStpBridgeForwardDelayField)).ignoreValue() && !this.validatedot1dStpBridgeForwardDelayField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.dot1dStpBridgeHelloTimeField)).ignoreValue() && !this.validatedot1dStpBridgeHelloTimeField()) {
                return false;
            }
            return ((JDMInput)((Object)this.dot1dStpBridgeMaxAgeField)).ignoreValue() || this.validatedot1dStpBridgeMaxAgeField();
        }
    }

    public class StpExtensionsSection
    extends PropertySection {
        ModelInfo chunk;
        Component stpExtEnableField;
        Component stpExtResetField;
        Label stpExtEnableFieldLabel;
        Label stpExtResetFieldLabel;
        boolean stpExtEnableFieldWritable = false;
        boolean stpExtResetFieldWritable = false;

        public StpExtensionsSection() {
            VBridgeBasePanel.this = VBridgeBasePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createstpExtEnableField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.StpExtensions.StpEnable.access", "read-write");
            this.stpExtEnableFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.stpExtEnableFieldLabel = new Label(VBridgeBasePanel.getNLSString("stpExtEnableLabel"), 2);
            if (this.stpExtEnableFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(LsBridgeExtsModel.StpExtensions.StpEnableEnum.symbolicValues, LsBridgeExtsModel.StpExtensions.StpEnableEnum.numericValues, VBridgeBasePanel.getEnumStrings());
                this.addRow(this.stpExtEnableFieldLabel, (Component)singleChoiceInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(LsBridgeExtsModel.StpExtensions.StpEnableEnum.symbolicValues, LsBridgeExtsModel.StpExtensions.StpEnableEnum.numericValues, VBridgeBasePanel.getEnumStrings());
            this.addRow(this.stpExtEnableFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getstpExtEnableField() {
            JDMInput jDMInput = (JDMInput)((Object)this.stpExtEnableField);
            this.validatestpExtEnableField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setstpExtEnableField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.stpExtEnableField);
                jDMInput.setValue(object);
                this.validatestpExtEnableField();
            }
        }

        protected boolean validatestpExtEnableField() {
            JDMInput jDMInput = (JDMInput)((Object)this.stpExtEnableField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.stpExtEnableFieldLabel.setForeground(Color.yellow);
            } else {
                this.stpExtEnableFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createstpExtResetField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.StpExtensions.StpResetToSTPDefaults.access", "read-write");
            this.stpExtResetFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.stpExtResetFieldLabel = new Label(VBridgeBasePanel.getNLSString("stpExtResetLabel"), 2);
            if (this.stpExtResetFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(LsBridgeExtsModel.StpExtensions.StpResetToSTPDefaultsEnum.symbolicValues, LsBridgeExtsModel.StpExtensions.StpResetToSTPDefaultsEnum.numericValues, VBridgeBasePanel.getEnumStrings());
                this.addRow(this.stpExtResetFieldLabel, (Component)singleChoiceInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(LsBridgeExtsModel.StpExtensions.StpResetToSTPDefaultsEnum.symbolicValues, LsBridgeExtsModel.StpExtensions.StpResetToSTPDefaultsEnum.numericValues, VBridgeBasePanel.getEnumStrings());
            this.addRow(this.stpExtResetFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getstpExtResetField() {
            JDMInput jDMInput = (JDMInput)((Object)this.stpExtResetField);
            this.validatestpExtResetField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setstpExtResetField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.stpExtResetField);
                jDMInput.setValue(object);
                this.validatestpExtResetField();
            }
        }

        protected boolean validatestpExtResetField() {
            JDMInput jDMInput = (JDMInput)((Object)this.stpExtResetField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.stpExtResetFieldLabel.setForeground(Color.yellow);
            } else {
                this.stpExtResetFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.stpExtEnableField = this.createstpExtEnableField();
            this.stpExtResetField = this.createstpExtResetField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.stpExtEnableField)).ignoreValue() && this.stpExtEnableFieldWritable) {
                    VBridgeBasePanel.this.StpExtensionsInfo.add("StpExtensions.StpEnable", this.getstpExtEnableField());
                }
                if (!((JDMInput)((Object)this.stpExtResetField)).ignoreValue() && this.stpExtResetFieldWritable) {
                    VBridgeBasePanel.this.StpExtensionsInfo.add("StpExtensions.StpResetToSTPDefaults", this.getstpExtResetField());
                    return;
                }
            } else {
                VBridgeBasePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            VBridgeBasePanel.this.displayMsg(VBridgeBasePanel.getNLSString("accessDataMsg"));
            try {
                this.setstpExtEnableField(VBridgeBasePanel.this.StpExtensionsInfo.get("StpExtensions.StpEnable"));
                this.setstpExtResetField(VBridgeBasePanel.this.StpExtensionsInfo.get("StpExtensions.StpResetToSTPDefaults"));
            }
            catch (NullPointerException nullPointerException) {}
            VBridgeBasePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.doLayout();
        }

        public boolean validateSection() {
            if (!((JDMInput)((Object)this.stpExtResetField)).ignoreValue() && !this.validatestpExtResetField()) {
                return false;
            }
            return ((JDMInput)((Object)this.stpExtEnableField)).ignoreValue() || this.validatestpExtEnableField();
        }
    }

    public class TransparentSection
    extends PropertySection {
        ModelInfo chunk;
        Component dot1dTpAgingTimeField;
        Label dot1dTpAgingTimeFieldLabel;
        boolean dot1dTpAgingTimeFieldWritable = false;

        public TransparentSection() {
            VBridgeBasePanel.this = VBridgeBasePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createdot1dTpAgingTimeField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.Panel.Dot1dTpAgingTime.access", "read-write");
            this.dot1dTpAgingTimeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.dot1dTpAgingTimeFieldLabel = new Label(VBridgeBasePanel.getNLSString("dot1dTpAgingTimeLabel"), 2);
            if (this.dot1dTpAgingTimeFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(10, 1000000);
                this.addRow(this.dot1dTpAgingTimeFieldLabel, (Component)numericInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.dot1dTpAgingTimeFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getdot1dTpAgingTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dTpAgingTimeField);
            this.validatedot1dTpAgingTimeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setdot1dTpAgingTimeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.dot1dTpAgingTimeField);
                jDMInput.setValue(object);
                this.validatedot1dTpAgingTimeField();
            }
        }

        protected boolean validatedot1dTpAgingTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.dot1dTpAgingTimeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.dot1dTpAgingTimeFieldLabel.setForeground(Color.yellow);
            } else {
                this.dot1dTpAgingTimeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.dot1dTpAgingTimeField = this.createdot1dTpAgingTimeField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.dot1dTpAgingTimeField)).ignoreValue() && this.dot1dTpAgingTimeFieldWritable) {
                    VBridgeBasePanel.this.PanelInfo.add("Panel.Dot1dTpAgingTime", this.getdot1dTpAgingTimeField());
                    return;
                }
            } else {
                VBridgeBasePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            VBridgeBasePanel.this.displayMsg(VBridgeBasePanel.getNLSString("accessDataMsg"));
            try {
                this.setdot1dTpAgingTimeField(VBridgeBasePanel.this.PanelInfo.get("Panel.Dot1dTpAgingTime"));
            }
            catch (NullPointerException nullPointerException) {}
            VBridgeBasePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.doLayout();
        }

        public boolean validateSection() {
            return ((JDMInput)((Object)this.dot1dTpAgingTimeField)).ignoreValue() || this.validatedot1dTpAgingTimeField();
        }
    }

    public class VBridgeWizardSection
    extends PropertySection {
        ModelInfo chunk;
        Component bridgeIDField;
        Component bridgeNameField;
        Component bridgePortsField;
        Label bridgeIDFieldLabel;
        Label bridgeNameFieldLabel;
        Label bridgePortsFieldLabel;
        boolean bridgeIDFieldWritable = false;
        boolean bridgeNameFieldWritable = false;
        boolean bridgePortsFieldWritable = false;

        public VBridgeWizardSection() {
            VBridgeBasePanel.this = VBridgeBasePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createbridgeIDField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.LsBridgeGenInfo.CreateBridgeId.access", "read-write");
            this.bridgeIDFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bridgeIDFieldLabel = new Label(VBridgeBasePanel.getNLSString("bridgeIDLabel"), 2);
            if (this.bridgeIDFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.bridgeIDFieldLabel, (Component)numericInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bridgeIDFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbridgeIDField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bridgeIDField);
            this.validatebridgeIDField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbridgeIDField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bridgeIDField);
                jDMInput.setValue(object);
                this.validatebridgeIDField();
            }
        }

        protected boolean validatebridgeIDField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bridgeIDField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bridgeIDFieldLabel.setForeground(Color.yellow);
            } else {
                this.bridgeIDFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbridgeNameField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.LsBridgeGenInfo.CreateBridgeName.access", "read-write");
            String string2 = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.LsBridgeGenInfo.CreateBridgeName.length", "255");
            this.bridgeNameFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bridgeNameFieldLabel = new Label(VBridgeBasePanel.getNLSString("bridgeNameLabel"), 2);
            if (this.bridgeNameFieldWritable) {
                StringInput stringInput = new StringInput();
                stringInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.bridgeNameFieldLabel, (Component)stringInput);
                VBridgeBasePanel.this.containsWritableField = true;
                return stringInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bridgeNameFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbridgeNameField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bridgeNameField);
            this.validatebridgeNameField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbridgeNameField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bridgeNameField);
                jDMInput.setValue(object);
                this.validatebridgeNameField();
            }
        }

        protected boolean validatebridgeNameField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bridgeNameField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bridgeNameFieldLabel.setForeground(Color.yellow);
            } else {
                this.bridgeNameFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbridgePortsField() {
            String string = VBridgeBasePanel.this.getOverride("ibm.nways.lspeed.model.LsBridgeExts.LsBridgeGenInfo.CreateBridgeListOfPorts.access", "read-write");
            this.bridgePortsFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bridgePortsFieldLabel = new Label(VBridgeBasePanel.getNLSString("bridgePortsLabel"), 2);
            if (this.bridgePortsFieldWritable) {
                VBridgePortsCreateWidget vBridgePortsCreateWidget = new VBridgePortsCreateWidget();
                this.addRow(this.bridgePortsFieldLabel, (Component)vBridgePortsCreateWidget);
                VBridgeBasePanel.this.containsWritableField = true;
                return vBridgePortsCreateWidget;
            }
            VBridgePortsCreateWidget vBridgePortsCreateWidget = new VBridgePortsCreateWidget();
            this.addRow(this.bridgePortsFieldLabel, (Component)vBridgePortsCreateWidget);
            return vBridgePortsCreateWidget;
        }

        protected Serializable getbridgePortsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bridgePortsField);
            this.validatebridgePortsField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbridgePortsField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bridgePortsField);
                jDMInput.setValue(object);
                this.validatebridgePortsField();
            }
        }

        protected boolean validatebridgePortsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bridgePortsField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bridgePortsFieldLabel.setForeground(Color.yellow);
            } else {
                this.bridgePortsFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.addSectionLabel(VBridgeBasePanel.getNLSString("bridgeIdInfoString"));
            this.addParagraph(VBridgeBasePanel.getNLSString("bridgeIdTextString"));
            this.bridgeIDField = this.createbridgeIDField();
            this.bridgeNameField = this.createbridgeNameField();
            this.addSectionLabel(VBridgeBasePanel.getNLSString("portsInfoString"));
            this.addParagraph(VBridgeBasePanel.getNLSString("portsInfoTextString"));
            this.bridgePortsField = this.createbridgePortsField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.bridgeIDField)).ignoreValue() && this.bridgeIDFieldWritable) {
                    VBridgeBasePanel.this.LsBridgeGenInfoInfo.add("LsBridgeGenInfo.CreateBridgeId", this.getbridgeIDField());
                }
                if (!((JDMInput)((Object)this.bridgeNameField)).ignoreValue() && this.bridgeNameFieldWritable) {
                    VBridgeBasePanel.this.LsBridgeGenInfoInfo.add("LsBridgeGenInfo.CreateBridgeName", this.getbridgeNameField());
                }
                if (!((JDMInput)((Object)this.bridgePortsField)).ignoreValue() && this.bridgePortsFieldWritable) {
                    VBridgeBasePanel.this.LsBridgeGenInfoInfo.add("LsBridgeGenInfo.CreateBridgeListOfPorts", this.getbridgePortsField());
                    return;
                }
            } else {
                VBridgeBasePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            VBridgeBasePanel.this.displayMsg(VBridgeBasePanel.getNLSString("accessDataMsg"));
            try {
                this.setbridgeIDField(VBridgeBasePanel.this.LsBridgeGenInfoInfo.get("LsBridgeGenInfo.CreateBridgeId"));
                this.setbridgeNameField(VBridgeBasePanel.this.LsBridgeGenInfoInfo.get("LsBridgeGenInfo.CreateBridgeName"));
                this.setbridgePortsField(VBridgeBasePanel.this.LsBridgeGenInfoInfo.get("LsBridgeGenInfo.CreateBridgeListOfPorts"));
            }
            catch (NullPointerException nullPointerException) {}
            VBridgeBasePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.doLayout();
        }

        public boolean validateSection() {
            if (!((JDMInput)((Object)this.bridgeIDField)).ignoreValue() && !this.validatebridgeIDField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.bridgeNameField)).ignoreValue() && !this.validatebridgeNameField()) {
                return false;
            }
            return ((JDMInput)((Object)this.bridgePortsField)).ignoreValue() || this.validatebridgePortsField();
        }
    }
}

